#version 140
#extension GL_EXT_gpu_shader4 : enable
//weird terrainMod01.fsh  by   polyrhythm
//https://www.shadertoy.com/view/ldlczH
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*1.77  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define saturate(x) clamp(x, 0.0, 1.0)
#define PI 3.14159265359
const vec3 SUN_DIR = normalize(vec3(0.2, 1.0, -0.75));

// ----------
// Noise
// ----------
vec3 mod289(vec3 x) 
{
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec2 mod289(vec2 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec3 permute(vec3 x) {
  return mod289(((x*34.0)+1.0)*x);
}

float snoise(vec2 v)
  {
  const vec4 C = vec4(0.211324865405187,  // (3.0-sqrt(3.0))/6.0
                      0.366025403784439,  // 0.5*(sqrt(3.0)-1.0)
                     -0.577350269189626,  // -1.0 + 2.0 * C.x
                      0.024390243902439); // 1.0 / 41.0

  vec2 i  = floor(v + dot(v, C.yy) );
  vec2 x0 = v -   i + dot(i, C.xx);


  vec2 i1;

  i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);

  vec4 x12 = x0.xyxy + C.xxzz;
  x12.xy -= i1;


  i = mod289(i); 
  vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 ))
    + i.x + vec3(0.0, i1.x, 1.0 ));

  vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);
  m = m*m ;
  m = m*m ;

  vec3 x = 2.0 * fract(p * C.www) - 1.0;
  vec3 h = abs(x) - 0.5;
  vec3 ox = floor(x + 0.5);
  vec3 a0 = x - ox;

  m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );

  vec3 g;
  g.x  = a0.x  * x0.x  + h.x  * x0.y;
  g.yz = a0.yz * x12.xz + h.yz * x12.yw;
  return 130.0 * dot(m, g);
}

// ---------------
// transformations
// ---------------
float degToRad(float deg) {
  return deg * (PI / 180.0);
}

mat3 rotateY(float deg) {
  float theta = degToRad(deg);
  float sinTh = sin(theta);
  float cosTh = cos(theta);
  return mat3(cosTh, 0.0, sinTh,
              0.0,   1.0, 0.0,
             -sinTh, 0.0, cosTh);
}

mat3 scale(vec3 s) {
  return mat3(s.x, 0.0, 0.0,
              0.0, s.y, 0.0,
              0.0, 0.0, s.z);
}

// ---------------
// terrain
// ---------------
float terrainMap(vec2 pos) {
  float scale = 0.01;
  const float amplitude = 13.0;
  pos *= scale;
  float time = iTime / 5.0;
  return snoise(pos) * amplitude;
}

// ---------------
// raytrace
// ---------------
vec2 trace(vec3 ro, vec3 rd) {
  float dist, th;
  const int MAX_STEPS = 400;
  const float minT = 5.0;
  const float maxT = 400.0;
  float t = minT;
  float origT = t;
  float origDist = 0.0;
  float height = 0.0;

  for (int i = 0; i < MAX_STEPS; i++) {
    th = 0.001 * t;
    vec3 p = ro + rd * t;
    float env = terrainMap(p.xz);
    dist = p.y - env;
    height = p.y;
    if (dist < th) {
      break;
    }

    origT = t;
    origDist = dist;
    t += 0.01 * t * dist * 0.6;

    if (t > maxT) break;
  }

  if (t > maxT) return vec2(-1.0);

  t = origT + (th - origDist) * (t - origT) / (dist - origDist);

  return vec2(t, height);
}

vec3 getNormal(const vec3 pos) {
  const float epsilon = 0.02;
  vec3 n = vec3(terrainMap(vec2(pos.x - epsilon, pos.z)) - terrainMap(vec2(pos.x + epsilon, pos.z)),
                2.0 * epsilon,
                terrainMap(vec2(pos.x, pos.z - epsilon)) - terrainMap(vec2(pos.x, pos.z + epsilon)));

  return normalize(n);
}

// ---------------
// render
// ---------------
vec3 renderSky(vec3 ro, vec3 rd) {
  vec3 col = 0.9 * vec3(0.8, 0.9, 1.0) - rd.y * vec3(0.75, 0.36, 0.4);

  return col;
}

vec3 getMaterial(vec3 pos, vec3 n) {
  vec3 green = vec3(0.2, 0.8, 0.1);
  vec3 brown = vec3(0.9, 0.8, 0.3);

  return 0.65 * mix(brown, green, smoothstep(0.4, 0.9, n.y));
}

float getShading(vec3 pos, vec3 n, float height) {
  return saturate(dot(SUN_DIR, n)) + height * 0.035;
}

vec3 applyFog(vec3 colour, float dist) {
  float fogAmount = 1.0 - exp(-dist * colour.z * 0.1);
  vec3 fogColour = vec3(0.5, 0.6, 0.7) * 0.8;
  return mix(colour, fogColour, fogAmount);
}

vec3 terrainColour(vec3 ro, vec3 rd, vec2 env) {
  vec3 pos = ro + rd * env.x;

  vec3 n = getNormal(pos);
  float s = getShading(pos, n, env.y);
  vec3 m = getMaterial(pos, n);

  return applyFog(m * s, env.x);
}

vec4 render(vec3 ro, vec3 rd) {
  vec4 col = vec4(0.0);
  vec2 env = trace(ro, rd);
  if (env.x != -1.0) {
    col = vec4(terrainColour(ro, rd, env), 1.0);
  }

  return col;
}

// ---------------
// Setup
// ---------------
mat3 setCamera(in vec3 origin, in vec3 target, float rotation) {
    vec3 forward = normalize(target - origin);
    vec3 orientation = vec3(sin(rotation), cos(rotation), 0.0);
    vec3 left = normalize(cross(forward, orientation));
    vec3 up = normalize(cross(left, forward));
    return mat3(left, up, forward);
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
{
  vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / iResolution.xy;
  p *= iResolution.xy / iResolution.y;

  vec3 colour = vec3(0.0);

  vec3 origin = vec3(0.0, 20.0, -40.0);
  origin.z += iTime * 1.5;
  origin.x += iTime;
  vec3 target = vec3(0.0, 0.0, 0.0);
  target.z += iTime * 1.5;
  target.x += iTime;
  mat3 toWorld = setCamera(origin, target, 0.0);
  vec3 rd = toWorld * normalize(vec3(p.xy, 1.25));

  // sky
  colour = renderSky(origin, rd);

  // terrain
  vec4 terrain = render(origin, rd);
  colour = colour * (1.0 - terrain.w) + terrain.xyz;

  gl_FragColor = vec4(colour, 1.0);
}